/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.BrowserNotifier;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorHistoryItem;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentFilesActionController
extends AbstractActionController {
    @ControllerAction
    public Object getRecentFiles() {
        EditorHistory editorHistory = ((Workbench)PortalUIPlugin.getDefault().getWorkbench()).getEditorHistory();
        EditorHistoryItem[] items = editorHistory.getItems();
        int itemsToShow = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("RECENT_FILES");
        LinkedHashMap<String, String> files = new LinkedHashMap<String, String>();
        if (items != null && itemsToShow > 0) {
            EditorHistoryItem[] editorHistoryItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                EditorHistoryItem item = editorHistoryItemArray[n2];
                IEditorDescriptor editorDescriptor = item.getDescriptor();
                if (editorDescriptor == null || !editorDescriptor.getId().startsWith("com.aptana.portal.ui")) {
                    if (itemsToShow-- == 0) break;
                    files.put(item.getName(), item.getToolTipText());
                }
                ++n2;
            }
        }
        return JSON.toString(files);
    }

    @ControllerAction
    public Object openRecentFiles(Object arguments) {
        if (!(arguments instanceof Object[])) {
            String message = "Wrong argument type passed to RecentFilesActionController::openRecentFile. Expected Object[] and got " + (arguments == null ? "null" : arguments.getClass().getName());
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
            return BrowserNotifier.toJSONErrorNotification("Argument Error", null);
        }
        Object[] args = (Object[])arguments;
        if (args != null && args.length > 0) {
            LinkedHashSet<String> filesToOpen = new LinkedHashSet<String>();
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                filesToOpen.add(file.toString());
                ++n2;
            }
            EditorHistory editorHistory = ((Workbench)PortalUIPlugin.getDefault().getWorkbench()).getEditorHistory();
            EditorHistoryItem[] items = editorHistory.getItems();
            if (items != null) {
                EditorHistoryItem[] editorHistoryItemArray = items;
                int n3 = items.length;
                int n4 = 0;
                while (n4 < n3) {
                    EditorHistoryItem item = editorHistoryItemArray[n4];
                    if (filesToOpen.contains(item.getToolTipText())) {
                        this.open(item);
                    }
                    ++n4;
                }
            }
        }
        return IBrowserNotificationConstants.JSON_OK;
    }

    private void open(EditorHistoryItem item) {
        IWorkbenchPage page = PortalUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            try {
                String itemName = item.getName();
                if (!item.isRestored()) {
                    item.restoreState();
                }
                IEditorInput input = item.getInput();
                IEditorDescriptor desc = item.getDescriptor();
                if (input == null || desc == null) {
                    String title = WorkbenchMessages.OpenRecent_errorTitle;
                    String msg = NLS.bind((String)WorkbenchMessages.OpenRecent_unableToOpen, (Object)itemName);
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg);
                } else {
                    page.openEditor(input, desc.getId());
                }
            }
            catch (PartInitException e2) {
                String title = WorkbenchMessages.OpenRecent_errorTitle;
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)title, (String)e2.getMessage());
            }
        }
    }

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
    }
}

